# Cuadro XI.4
# Regresin logstica binomial
########################################################
# Seccin modificable por el usuario
########################################################

#Cargar archivo de datos
datos<-read.csv2("Cuadro XI.4.V.csv",header=TRUE,enc="latin1")

#Seleccionar variables respuesta y predictoras.
#Las predictoras deben escribirse entre las comillas en el vector "varpred".
varesp<-"Producto"
varpred<-paste("Estrato.econmico","Edad",sep="+")

#Seleccionar dentro de la variable respuesta el valor
#respecto al que hay que transformar la variable respuesta en binaria (0/1)
gruporesp<-("Compra")

#Seleccionar si se quiere trabajar con todas las
#variables independientes, o utilizar mtodos "forward" y "backwards".
#variables<-c("todas")
variables<-c("backwards","forward")

#Variables de seleccin de datos.
#varSeleccion1<-list(c("Sexo","Hombre"))
varSeleccion1<-NULL
#varSeleccion2<-list(c("","",""))
varSeleccion2<-NULL

#Nombre del archivo de salida
ArchivodeSalida<-"Salida Cuadro XI.4.txt"

#Nombre del archivo csv con los valores de los coeficientes
CSV<-"Salida Cuadro XI.4-1.csv"

#Nombre del archivo csv con los valores de probabilidad
CSVp<-"Salida Cuadro XI.4-2.csv"

########################################################
# Seccin que realiza el procedimiento
########################################################

#Selecciones
if (length(varSeleccion1)!=0){
 w1<-data.frame(row.names=1:dim(datos)[1])
 varBin1<-as.character()
 for (i in 1:length(varSeleccion1)){
   nom1<-varSeleccion1[[i]][1]
   x1<-factor(datos[,nom1])
   if (length(varSeleccion1[[i]])>1){
      sufijo1<-paste(varSeleccion1[[i]][2:3],collapse="_")
      nom1<-paste(nom1,".",sufijo1,sep="")
      x11<-factor(ifelse(x1 %in% varSeleccion1[[i]][2:3],as.character(x1),NA))
      x11<-data.frame(factor(x11))
   }else{
      x11<-x1
      x11<-data.frame(x1)
   }
   names(x11)<-nom1
   varBin1<-c(varBin1,nom1)
   w1<-data.frame(w1,x11)
 }
}

if (length(varSeleccion2)!=0){
 w2<-data.frame(row.names=1:dim(datos)[1])
 varBin2<-as.character()
 for (i in 1:length(varSeleccion2)){
   nom2<-varSeleccion2[[i]][1]
   x2<-factor(datos[,nom2])
   if (length(varSeleccion2[[i]])>1){
      sufijo2<-paste(varSeleccion2[[i]][2:3],collapse="_")
      nom2<-paste(nom2,".",sufijo2,sep="")
      x12<-factor(ifelse(x2 %in% varSeleccion2[[i]][2:3],as.character(x2),NA))
      x12<-data.frame(factor(x12))
   }else{
      x12<-x2
      x12<-data.frame(x2)
   }
   names(x12)<-nom2
   varBin2<-c(varBin2,nom2)
   w2<-data.frame(w2,x12)
 }
}

if ((length(varSeleccion1)!=0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w1,w2)
if ((length(varSeleccion1)!=0)&(length(varSeleccion2)==0)) seleccion<-data.frame(w1)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w2)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)==0)) seleccion<-NULL

#Aplicar seleccin a datos
if (length(seleccion)==0) datos2<-data.frame(datos)
if (length(seleccion)!=0) datos2<-data.frame(seleccion,datos)
datos<-na.omit(datos2)

#Crear variable binaria
varbin<-datos[,varesp]
varbinaria<-ifelse(varbin==gruporesp,1,0)

#nuevo conjunto de datos
datos3<-data.frame(varrespuesta=varbinaria,datos)

#Modelo de regresin logstica.
attach(datos3)
formula<-as.formula(paste("varrespuesta~",paste(varpred)))
modelo<-glm(formula,family=binomial("logit"))
if(length(variables)==2)modelo.2<-step(modelo)
if(length(variables)==1)modelo.2<-modelo
Resumenmodelo<-(summary(modelo.2))

predicciones<-round(predict(modelo.2, type="response"))
prob<-(predict(modelo.2, type="response"))
grupopertenencia<-datos3[,varesp]
Prediccionesmodelo<-data.frame(predicciones,grupopertenencia)
Predicbin<-ifelse(Prediccionesmodelo$grupopertenencia==gruporesp,1,0)
Prediccionesmodelo<-data.frame(predicciones,Predicbin)
correct<-as.vector(ifelse(Prediccionesmodelo$predicciones==Prediccionesmodelo$Predicbin,1,0))
total<-length(correct)
aciertos<-which(correct==1)
totalaciertos<-length(aciertos)
prctacierto<-(totalaciertos/total)*100
resultadocls<-c("Porcentaje correctamente clasificado total",prctacierto)
total1<-data.frame(Prediccionesmodelo[Prediccionesmodelo$Predicbin==1,])
aciertos1<-data.frame(total1[total1$predicciones==total1$Predicbin,])
totalaciertos1<-nrow(aciertos1)
tot1<-nrow(total1)
prctacierto1<-(totalaciertos1/tot1)*100
resultadocls1<-c(paste("Porcentaje correctamente clasificado",varesp,gruporesp,collapse=""),prctacierto1)
total0<-data.frame(Prediccionesmodelo[Prediccionesmodelo$Predicbin==0,])
aciertos0<-data.frame(total0[total0$predicciones==total0$Predicbin,])
totalaciertos0<-nrow(aciertos0)
tot0<-nrow(total0)
prctacierto0<-(totalaciertos0/tot0)*100
resultadocls0<-c(paste("Porcentaje correctamente clasificado",varesp,"No",gruporesp,collapse=""),prctacierto0)

########################################################
# Seccin que muestra los resultados
########################################################

#Archivo con los coeficientes de la ecuacin
write.csv2(modelo.2$coefficients,file=CSV)

#Archivo con los valores de probabilidada para cada caso
write.csv2(prob,file=CSVp)

if(!is.null(ArchivodeSalida)){
 sink(ArchivodeSalida)
 print(Resumenmodelo)
 print(resultadocls)
 print(resultadocls1)
 print(resultadocls0)
 sink()
}

